/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.launching;

import com.aptana.core.util.StringUtil;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.php.debug.ui.launching.LaunchConfigurationsSelectionDialog;
import com.aptana.webserver.core.IServer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.util.SWTUtil;

public class PathMappingUpdater {
    public void updatePaths(IServer server) {
        this.updatePaths(server, null);
    }

    public void updatePaths(IServer server, String[] excludedLaunches) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType configurationType = launchManager.getLaunchConfigurationType("com.aptana.php.debug.core.launching.webPageLaunch");
            ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(configurationType);
            ArrayList<ILaunchConfiguration> launchConfigurations = new ArrayList<ILaunchConfiguration>();
            Collections.addAll(launchConfigurations, configs);
            if (excludedLaunches != null) {
                String[] stringArray = excludedLaunches;
                int n = excludedLaunches.length;
                int n2 = 0;
                while (n2 < n) {
                    String exclude = stringArray[n2];
                    int i = launchConfigurations.size() - 1;
                    while (i >= 0) {
                        if (((ILaunchConfiguration)launchConfigurations.get(i)).getName().equals(exclude)) {
                            launchConfigurations.remove(i);
                            break;
                        }
                        --i;
                    }
                    ++n2;
                }
            }
            this.filterByLaunchAttributes(launchConfigurations, server);
            if (!launchConfigurations.isEmpty()) {
                this.filterBySelection(launchConfigurations);
            }
            if (!launchConfigurations.isEmpty()) {
                PathMappingUpdater.updateConfigurations(launchConfigurations, server);
            }
        }
        catch (CoreException ce) {
            PHPDebugEPLPlugin.logError("Error while trying to propogate the PHP Server path mapping to the PHP web launch configurations", ce);
        }
    }

    private void filterByLaunchAttributes(List<ILaunchConfiguration> launchConfigurations, IServer server) throws CoreException {
        int i = launchConfigurations.size() - 1;
        while (i >= 0) {
            ILaunchConfiguration launchConfiguration = launchConfigurations.get(i);
            boolean usesSpecifiedScript = launchConfiguration.getAttribute("ATTR_USE_SPECIFIC_FILE", false);
            if (!(server.getName().equals(launchConfiguration.getAttribute("ATTR_SERVER_NAME", "")) && usesSpecifiedScript && launchConfiguration.getAttribute("ATTR_AUTO_GENERATED_URL", false))) {
                launchConfigurations.remove(i);
            }
            --i;
        }
    }

    private void filterBySelection(List<ILaunchConfiguration> launchConfigurations) {
        Object[] result;
        LaunchConfigurationsSelectionDialog dialog = new LaunchConfigurationsSelectionDialog(SWTUtil.getStandardDisplay().getActiveShell(), launchConfigurations);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null) {
            launchConfigurations.clear();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                launchConfigurations.add((ILaunchConfiguration)o);
                ++n2;
            }
            return;
        }
        launchConfigurations.clear();
    }

    public static void updateConfigurations(List<ILaunchConfiguration> configurations, IServer server) throws CoreException {
        for (ILaunchConfiguration configuration : configurations) {
            String fileName = configuration.getAttribute("ATTR_SERVER_FILE_NAME", "");
            if (StringUtil.isEmpty((String)fileName)) continue;
            fileName = fileName.replace('\\', '/');
            URL newURL = server.getBaseURL();
            PathMapper pathMapper = PathMapperRegistry.getByServer(server);
            String remoteFile = pathMapper.getRemoteFile(fileName);
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            if (!StringUtil.isEmpty((String)remoteFile) && !remoteFile.equals(fileName)) {
                workingCopy.setAttribute("ATTR_SERVER_BASE_URL", newURL + remoteFile);
            } else {
                workingCopy.setAttribute("ATTR_SERVER_BASE_URL", newURL + fileName);
            }
            workingCopy.doSave();
        }
    }
}

